#define hs_create_highscore
//Erstellt eine neue Highscore
//argument0: Spalten, getrennt mit |; z.B. Name|Score
//return: Highscore Handle

var grid, cols, i;

cols = hs_dataset_split(argument0);

grid = ds_grid_create(ds_list_size(cols), 1);
for (i=0; i < ds_list_size(cols); i+=1)
{
    ds_grid_set(grid, i, 0, ds_list_find_value(cols, i));
}

ds_list_destroy(cols);

return grid;


#define hs_destroy
//Lscht eine Highscore
//argument0: Highscore

ds_grid_destroy(argument0);

#define hs_add
//Fgt einen Datensatz am Ende der Highscore ein
//argument0: Highscore
//argument1: Datensatz-String

var cols, i;

cols = hs_dataset_split(argument1);

ds_grid_resize(argument0, ds_grid_width(argument0), ds_grid_height(argument0)+1); 

for (i=0; i < ds_grid_width(argument0); i+=1)
{
    ds_grid_set(argument0, i, ds_grid_height(argument0)-1, ds_list_find_value(cols, i));
}

ds_list_destroy(cols);

#define hs_insert
//Fgt einen Eintrag an einer bestimmten Position ein
//argument0: Highscore
//argument1: Position
//argument2: Datensatz-String

var i;

ds_grid_resize(argument0, ds_grid_width(argument0), ds_grid_height(argument0)+1);

for (i=ds_grid_height(argument0)-1; i > argument1; i-=1)
{
    hs_set(argument0, i, hs_get(argument0, i-1));
}

hs_set(argument0, argument1, argument2);

#define hs_set
//berschreibt einen Datensatz
//argument0: Highscore
//argument1: Position
//argument2: Datensatz-String

var cols, i;

cols = hs_dataset_split(argument2);

for (i=0; i < ds_grid_width(argument0); i+=1)
{
    ds_grid_set(argument0, i, argument1, ds_list_find_value(cols, i));
}

ds_list_destroy(cols);

#define hs_get
//Gibt einen Datensatz-String mit den Werten des Eintrags an der gegebenen Position zurck.
//argument0: Highscore
//argument1: Position

var i, s;
s = "";

for (i=0; i < ds_grid_width(argument0); i+=1)
{
    s += string(ds_grid_get(argument0, i, argument1))+"|";
}

return string_copy(s, 1, string_length(s)-1);

#define hs_get_value
//Gibt den Wert an der angegebenen Position in der angegebenen Spalte zurck
//argument0: Highscore
//argument1: Spalte
//argument2: Position
//return: Wert an der Position in der Spalte

return ds_grid_get(argument0, hs_find_column(argument0, argument1), argument2);

#define hs_get_colwidth
//Gibt die Breite (in Pixel) einer Spalte zurck
//argument0: Highscore
//argument1: Spalte
//return: Breite (in Pixel)

var i, tmp, col;
tmp = 0;

for (i=0; i < ds_grid_width(argument0); i+=1)
{
    if (ds_grid_get(argument0, i, 0) == argument1)
    {
        col = i;
        break;
    }
}

for (i=0; i < ds_grid_height(argument0); i+=1)
{
    tmp = max(tmp, string_width(ds_grid_get(argument0, col, i)));
}

return tmp;

#define hs_get_length
//Gibt die Lnge der Highscore zurck
//argument0: Highscore
//return: Lnge der Highscore

return ds_grid_height(argument0) - 1;

#define hs_find_column
//Gibt die Position einer Spalte zurck.
//argument0: Highscore
//argument1: Spalte
//return: Position der Spalte oder -1

var i;
for (i=0; i < ds_grid_width(argument0); i+=1)
{
    if (ds_grid_get(argument0, i, 0) == argument1)
    {
        return i;
    }
}
return -1;

#define hs_find_entry
//Gibt die Position des ersten Vorkommens eines Wertes zurck
//argument0: Highscore
//argument1: Spalte
//argument2: Wert
//return: Position des ersten Vorkommens des Wertes oder -1

var i, col;
col = hs_find_column(argument0, argument1);

for (i=1; i < ds_grid_height(argument0); i+=1)
{
    if (ds_grid_get(argument0, col, i) == argument2)
    {
        return i;
    }
}
return -1;

#define hs_remove
//Lscht den letzten Eintrag aus der Highscore
//argument0: Highscore

if (ds_grid_height(argument0) > 1)
{
    ds_grid_resize(argument0, ds_grid_width(argument0), ds_grid_height(argument0)-1);
}

#define hs_remove_at
//Lscht den Eintrag an der gegebenen Position aus der Highscore
//argument0: Highscore
//argument1: Position

if (ds_grid_height(argument0) > 1)
{
    var i;
    
    for (i=argument1+1; i < ds_grid_height(argument0); i+=1)
    {
        hs_set(argument0, i-1, hs_get(argument0, i));
    }
    
    ds_grid_resize(argument0, ds_grid_width(argument0), ds_grid_height(argument0)-1);
}

#define hs_clear
//Leert sie Highscore
//argument0: Highscore

ds_grid_resize(argument0, ds_grid_width(argument), 1);

#define hs_sort
//Sortiert die Highscore
//argument0: Highscore
//argument1: Spalte nach der sortiert werden soll
//argument2: absteigend: true/false

var i, ii, list, col, tmp;

col = hs_find_column(argument0, argument1);

for (i=1; i < ds_grid_height(argument0); i+=1)
{
    for (ii=1; ii < ds_grid_height(argument0)-1; ii+=1)
    {
        if (argument2)
        {
            if (real(ds_grid_get(argument0, col, ii)) < real(ds_grid_get(argument0, col, ii+1)))
            {
                tmp = hs_get(argument0, ii);
                hs_set(argument0, ii, hs_get(argument0, ii+1));
                hs_set(argument0, ii+1, tmp);
            }
        }
        else
        {
            if (real(ds_grid_get(argument0, col, ii)) > real(ds_grid_get(argument0, col, ii+1)))
            {
                tmp = hs_get(argument0, ii);
                hs_set(argument0, ii, hs_get(argument0, ii+1));
                hs_set(argument0, ii+1, tmp);
            }
        }
    }
}

#define hs_draw
//Zeichnet eine Highscore
//argument0: Highscore
//argument1: x
//argument2: y
//argument3: Lnge oder -1
//argument4: Nummerierung: true/false
//argument5: Horizontaler Abstand
//argument6: Vertikaler Abstand

var xx, yy, ii, i, len;
xx = argument1;

if (argument3 == -1)
{
    len = ds_grid_height(argument0);
}
else
{
    len = argument3;
}

if (argument4)
{
    ii = -1;
}
else
{
    ii = 0;
}

while (ii < ds_grid_width(argument0))
{
    yy = argument2;
    
    for (i=0; i < len; i+=1)
    {
        if (ii == -1)
        {
            if (i > 0)
            {
                draw_text(xx, yy, string(i)+".");
            }
        }
        else
        {
            draw_text(xx, yy, ds_grid_get(argument0, ii, i));
        }
        yy += string_height("X") + argument6;
    }
    
    if (ii == -1)
    {
        xx += string_width(string(i)) + argument5;
    }
    else
    {
        xx += hs_get_colwidth(argument0, ds_grid_get(argument0, ii, 0)) + argument5;
    }
    ii+=1;
}



#define hs_save
//Speichert eine Highscore in einer Datei
//argument0: Highscore
//argument1: Dateiname
//argument2: Zeichenverschiebung (Verschlsselung)

var f, xx, yy, out;

out = string(ds_grid_width(argument0)) + chr(10);
out += string(ds_grid_height(argument0)) + chr(10);

for (yy=0; yy < ds_grid_height(argument); yy+=1)
{
    for (xx=0; xx < ds_grid_width(argument); xx+=1)
    {
        out += string(ds_grid_get(argument0, xx, yy)) + chr(10);
    }
}

f = file_bin_open(argument1, 1);
file_bin_rewrite(f);
for (xx=1; xx <= string_length(out); xx+=1)
{
    file_bin_write_byte(f, ord(string_char_at(out, xx)) + argument2);
}
file_bin_close(f);

#define hs_load
//Ldt eine Highscore aus einer Datei
//argument0: Dateiname
//argument1: Zeichenverschiebung (Verschlsselung)
//return: Highscore Handle

var f, xx, yy, char, tmp, w, grid;
w = -1;
yy = 0;
xx = 0;

f = file_bin_open(argument0, 0);
while (file_bin_position(f) < file_bin_size(f))
{
    tmp = "";
    char = chr(file_bin_read_byte(f) - argument1);
    while (char != chr(10))
    {
        tmp += char
        char = chr(file_bin_read_byte(f) - argument1);
    }
    if (w == -1)
    {
        w = real(tmp);
    }
    else if (w > -1)
    {
        grid = ds_grid_create(w, real(tmp));
        w = -2;
    }
    else
    {
        ds_grid_set(grid, xx, yy, tmp);
        
        xx += 1;
        if (xx == ds_grid_width(grid))
        {
            xx = 0;
            yy += 1;
        }
    }
}
file_bin_close(f);
return grid;

#define hs_dataset_split
//Teilt einen Datensatz-String in einzelne Werte auf und speichert sie in einer Liste
//argument0: Datensatz-String
//return: Liste mit Werten

var grid, cols, i, tmp;

cols = ds_list_create();
tmp = "";

for (i=1; i <= string_length(argument0); i+=1)
{
    if (string_char_at(argument0, i) != "|")
    {
        tmp += string_char_at(argument0, i);
    }
    else
    {
        ds_list_add(cols, tmp);
        tmp = "";
    }
}
if (tmp != "")
{
    ds_list_add(cols, tmp);
}

return cols;

