#define d3d_create
{
  friction = 0.2;
  draw_set_alpha(1);
  draw_set_color(c_white);
  d3d_start();
  d3d_set_hidden(true);
  d3d_set_lighting(false);
  d3d_set_culling(false);
  texture_set_interpolation(true);
}

#define d3d_draw
{
  d3d_set_projection(x,y,10, x+cos(direction*pi/180),y-sin(direction*pi/180),10, 0,0,1);
  d3d_draw_floor(0,0,0,room_width,room_height,0,background_get_texture(bg_floor),true,true)
  d3d_draw_floor(0,0,64,room_width,room_height,64,background_get_texture(bg_sky),true,true)
}


#define d3d_step
{
if(keyboard_check(vk_left))     {direction+=2}
if(keyboard_check(vk_right))    {direction-=2}
if(keyboard_check(vk_up))       {if(speed < 2){speed = min(2,speed+0.4);}}
if(keyboard_check(vk_down))     {if(speed > -2){speed = min(-2,speed-0.4);}}
}
#define d3d_draw_wall_hor
{
d3d_draw_wall(x-16,y,64,x+16,y,0,background_get_texture(bg_wall),1,1)
}
#define d3d_draw_wall_vert
{
d3d_draw_wall(x,y-16,64,x,y+16,0,background_get_texture(bg_wall),true,true)
}
#define d3d_water_init
{
///////////////////////////////////////////////////////////
//     argument0 => wasserbreite                         //
//     argument1 => wasserlnge                          //
//     argument2 => wasserhhe                           //
//     argument3 => wellengeschwindigkeit (1=normal)     //
//     argument4 => textur                               //
//                                                       //
//     Alles Scripts drfen frei benutzt werden,         //
//     ber einen Crediteintrag wre ich sehr            //
//     dankbar.                                          //
//                                                       //
//     Sascha Scherrer (alias Dragoon)                   //
///////////////////////////////////////////////////////////
width=round(argument0/8)-1;
height=round(argument1/8)-1;
waterz=argument2
water_texture=argument4
water_i1=0;
water_i2=0;
do
    {
    do
        {
        water_zspeed[water_i1,water_i2]=random(argument3)/100+0.005;
        water_z[water_i1,water_i2]=waterz+random(1);
        water_down[water_i1,water_i2]=choose(1,0);
        water_i2+=1;
        }
    until(water_i2-1>height)
    water_i2=0;
    water_i1+=1;
    }
until(water_i1-1>width)
}
#define d3d_water_move
{
water_i1=0;
water_i2=0;
do
    {
    do
        {
        if(water_z[water_i1,water_i2]>waterz+1){water_down[water_i1,water_i2]=1}
        if(water_z[water_i1,water_i2]<waterz){water_down[water_i1,water_i2]=0}
        if(water_down[water_i1,water_i2]=1)
        {water_z[water_i1,water_i2]-=water_zspeed[water_i1,water_i2];}
        else
        {water_z[water_i1,water_i2]+=water_zspeed[water_i1,water_i2];}
        water_i2+=1;
        }
    until(water_i2-1>height)
    water_i1+=1;
    water_i2=0;
    }
until(water_i1-1>width)
}
#define d3d_water_draw
{
d3d_water_move()
water_i1=0;
water_i2=0;
do
    {
    do
        {
        d3d_primitive_begin_texture(pr_trianglelist,background_get_texture(water_texture))
        d3d_vertex_texture(x+water_i1*8,y+water_i2*8,water_z[water_i1,water_i2],0,0)
        d3d_vertex_texture(x+(water_i1+1)*8,y+water_i2*8,water_z[water_i1+1,water_i2],1,0)
        d3d_vertex_texture(x+water_i1*8,y+(water_i2+1)*8,water_z[water_i1,water_i2+1],0,1)
        d3d_vertex_texture(x+(water_i1+1)*8,y+water_i2*8,water_z[water_i1+1,water_i2],1,0)
        d3d_vertex_texture(x+(water_i1+1)*8,y+(water_i2+1)*8,water_z[water_i1+1,water_i2+1],1,1)
        d3d_vertex_texture(x+water_i1*8,y+(water_i2+1)*8,water_z[water_i1,water_i2+1],0,1)
        d3d_primitive_end()
        water_i2+=1;
        }
    until(water_i2>height)
    water_i1+=1;
    water_i2=0;
    }
until(water_i1>width)
}
