#define puzzle_init
{
//////////////////////////////////////////////////////////////
//                                                          //
//        PUZZLE SCRIPT BY DRAGOON (SASCHA SCHERRER)        //
//                                                          //
//////////////////////////////////////////////////////////////
//puzzle_init(x,y,hpuzzles,vpuzzles,sprite,background-alpha)//
//////////////////////////////////////////////////////////////

//Initalisieren...
pz_sx=argument0;
pz_sy=argument1;
pz_countx=argument2;
pz_county=argument3;
sprite_index=argument4;
pz_alpha=argument5;
pz_w=sprite_width/pz_countx;
pz_h=sprite_height/pz_county;
pz_total=pz_countx*pz_county;
pz_done=false;
pz_savex[0]=0;
pz_savey[0]=0;
//Surface aufzeichnen
pz_sf=surface_create(sprite_width,sprite_height);
surface_set_target(pz_sf);
draw_sprite(sprite_index,0,0,0);
surface_reset_target();
//Zufllige Puzzelteilsetzung initialisieren
i=0;
repeat(pz_total)
    {
    pz_number[i]=false;
    i+=1;
    }
//Puzzleteilchen nach Zufall verteilen
i=0;
repeat(pz_total)
    {
    do{rnd=floor(random(pz_total));}until(pz_number[rnd]=false);
    pz_number[rnd]=true;
    pz_vert=floor(rnd/pz_countx);
    pz_hor=rnd-pz_vert*pz_countx;
    pz_x[i]=pz_sx+pz_hor*pz_w;
    pz_y[i]=pz_sy+pz_vert*pz_h;
    i+=1;
    }
i=0;
repeat(pz_total)
    {
    pz_savex[i]=pz_x[i];
    pz_savey[i]=pz_y[i];
    i+=1;
    }
//Alle deaktivieren
i=0;
repeat(pz_total)
    {
    pz_aktiv[i]=false;
    i+=1;
    }
}
#define puzzle_draw
{
//Beenden fals fertig
if(pz_done=true){return true;exit;}
//Wenn angeklickt, aktivieren
if(mouse_check_button_pressed(mb_left))
    {
    i=0;
    repeat(pz_total)
        {
        if(mouse_x>pz_x[i])and
        (mouse_x<pz_x[i]+pz_w)and
        (mouse_y>pz_y[i])and
        (mouse_y<pz_y[i]+pz_h)
            {pz_aktiv[i]=true;pz_savex[i]=pz_x[i];pz_savey[i]=pz_y[i];}
        else
            {pz_aktiv[i]=false;}
        i+=1;
        }
    }
//Alle deaktivieren, fals Mausknopf losgelassen
if(mouse_check_button_released(mb_left))
    {
    i=0;
    repeat(pz_total)
        {
        pz_aktiv[i]=false;
        pz_x[i]=round((pz_x[i]-pz_sx)/pz_w)*pz_w+pz_sx;
        pz_y[i]=round((pz_y[i]-pz_sy)/pz_h)*pz_h+pz_sy;
        i2=0;
        repeat(pz_total)
            {
            if((pz_x[i]=pz_x[i2])and(pz_y[i]=pz_y[i2])and(i!=i2)){pz_x[i]=pz_savex[i];pz_y[i]=pz_savey[i];}
            i2+=1;
            }
        i+=1;
        }
    }
//Wenn aktiv,bewegen
i=0;
repeat(pz_total)
    {
    if(pz_aktiv[i]=true)
        {
        pz_x[i]=mouse_x-pz_w/2;
        pz_y[i]=mouse_y-pz_h/2;
        }
    i+=1;
    }
//Testen, ob alle richtig sind
i=0;pz_done=0;
repeat(pz_total)
    {
    pz_vert=floor(i/pz_countx);
    pz_hor=i-pz_vert*pz_countx;
    
    if(pz_x[i]=pz_sx+pz_hor*pz_w)and(pz_y[i]=pz_sy+pz_vert*pz_h)
        {pz_done+=1;}
    i+=1;
    }
//Wenn alle richtig sind, pz_done auf TRUE setzen
if(pz_done>=pz_total){pz_done=true;}else{pz_done=false;}
//Ganzes Puzzle zeichnen
draw_surface_ext(pz_sf,pz_sx,pz_sy,1,1,0,c_white,pz_alpha);
//Puzzleteile zeichnen
i=0;
pz_akt=-1;
repeat(pz_total)
    {
    pz_vert=floor(i/pz_countx);
    pz_hor=i-pz_vert*pz_countx;
    if(pz_aktiv[i]=false)
        {draw_surface_part(pz_sf,pz_hor*pz_w,pz_vert*pz_h,pz_w,pz_h,pz_x[i],pz_y[i]);}
    else
        {pz_akt=i;}//Aktiviertes Teil nicht zeichnen, aber abspeichern
    i+=1;
    }
if(pz_akt=-1){exit;}
//Zeichne ausgelassenes Puzzle-Teil
i=pz_akt;
pz_vert=floor(i/pz_countx);
pz_hor=i-pz_vert*pz_countx;
draw_surface_part(pz_sf,pz_hor*pz_w,pz_vert*pz_h,pz_w,pz_h,pz_x[i],pz_y[i]);
}
