
#define ftp_init
/*
FTP DLL version 0.3
(c) 2004 Cygnus

Zum Verwenden: *) ftp.dll in Spieleverzeichnis oder als Data-File
               *) ftp.gml einbinden
               *) dieses Script 1x aufrufen
               
               
Voraussichtliche Features in 0.4:
        *) Dateien direkt am Server ffen, lesen & schreiben
        *) bessere Fehlerbehandlung
*/


//folgende globale Variablen NICHT verndern!!!

//Verbinden
global.ftp_conn       = external_define("ftp.dll","ftp_connect",dll_cdecl,ty_real,3,ty_string,ty_string,ty_string);
global.ftp_disconn    = external_define("ftp.dll","ftp_disconnect",dll_cdecl,ty_real,1,ty_real);

//Dateien
global.ftp_upload     = external_define("ftp.dll","ftp_file_upload",dll_cdecl,ty_real,4,ty_real,ty_string,ty_string,ty_real);
global.ftp_download   = external_define("ftp.dll","ftp_file_download",dll_cdecl,ty_real,4,ty_real,ty_string,ty_string,ty_real);
global.ftp_findfirst  = external_define("ftp.dll","ftp_file_find_first",dll_cdecl,ty_string,3,ty_real,ty_string,ty_real);
global.ftp_findnext   = external_define("ftp.dll","ftp_file_find_next",dll_cdecl,ty_string,0);
global.ftp_closefind  = external_define("ftp.dll","ftp_file_find_close",dll_cdecl,ty_real,0);
global.ftp_rename     = external_define("ftp.dll","ftp_file_rename",dll_cdecl,ty_real,3,ty_real,ty_string,ty_string);
global.ftp_delete     = external_define("ftp.dll","ftp_file_delete",dll_cdecl,ty_real,2,ty_real,ty_string);

//Verzeichnisse
global.ftp_makedir    = external_define("ftp.dll","ftp_directory_create",dll_cdecl,ty_real,2,ty_real,ty_string);
global.ftp_remdir     = external_define("ftp.dll","ftp_directory_remove",dll_cdecl,ty_real,2,ty_real,ty_string);
global.ftp_getcurdir  = external_define("ftp.dll","ftp_get_directory",dll_cdecl,ty_string,1,ty_real);
global.ftp_setcurdir  = external_define("ftp.dll","ftp_set_directory",dll_cdecl,ty_real,2,ty_real,ty_string);

//HINTERNET-Handle
global.hConnection = 0;

#define ftp_connect
//Verbindet mit einem FTP-Server
//arg0: [string] Server (z.B. "ftp.tripod.com" oder "63.203.77.145")
//arg1: [string] Username
//arg2: [string] Passwort

global.hConnection = external_call(global.ftp_conn,argument0,argument1,argument2);

return global.hConnection != 0;

#define ftp_is_connected
//Gibt zurck, ob Verbindung besteht
//keine Argumente
return global.hConnection != 0;

#define ftp_disconnect
//Beendet die Verbindung zum FTP-Server
//keine Argumente
if (!global.hConnection)
{
    show_error("keine aktive FTP-Verbindung",false);
    exit;
}

external_call(global.ftp_disconn,global.hConnection);

#define ftp_file_upload
//Ldt eine Datei auf den FTP-Server hoch; Erfolgsmeldung
//arg0: [string] Dateiname 
//arg1: [string] Name der neuen Datei am Server
//arg2: [real]  Modus zum bertragen: 0 = binary , 1 = ASCII

if (!global.hConnection)
{
    show_error("keine aktive FTP-Verbindung",false);
    return false;
}

return external_call(global.ftp_upload,global.hConnection,argument0,argument1,argument2);

#define ftp_file_download
//Ldt eine Datei vom FTP-Server herunter; Erfolgsmeldung
//arg0: [string] Name der neuen Datei
//arg1: [string] Dateiname der Datei am Server
//arg2: [real]  Modus zum bertragen: 0 = binary , 1 = ASCII

if (!global.hConnection)
{
    show_error("keine aktive FTP-Verbindung",false);
    return false;
}

return external_call(global.ftp_download,global.hConnection,argument0,argument1,argument2);

#define ftp_directory_create
//Erstellt ein Verzeichnis am Server; Erfolgsmeldung
//arg0: [string] Verzeichnisname
if (!global.hConnection)
{
    show_error("keine aktive FTP-Verbindung",false);
    return false;
}

return external_call(global.ftp_makedir,global.hConnection,argument0);

#define ftp_directory_remove
//Lscht ein Verzeichnis am Server
//arg0: [string] Verzeichnisname

if (!global.hConnection)
{
    show_error("keine aktive FTP-Verbindung",false);
    return false;
}

return external_call(global.ftp_remdir,global.hConnection,argument0);

#define ftp_set_current_directory
//Setzt das aktuelle Verzeichnis am Server; Erfolgsmeldung
//arg0: [string] neues aktuelles Verzeichnis
if (!global.hConnection)
{
    show_error("keine aktive FTP-Verbindung",false);
    return false;
}

return external_call(global.ftp_setcurdir,global.hConnection,argument0);

#define ftp_get_current_directory
//Gibt aktuelles Verzeichnis am Server zurck
//keine Argumente
if (!global.hConnection)
{
    show_error("keine aktive FTP-Verbindung",false);
    return false;
}

return external_call(global.ftp_getcurdir,global.hConnection);

#define ftp_file_find_first
//Beginnt Dateiauflistung (siehe file_find_first in GM-Hilfe)
//Gibt 1. gefundene Datei zurck

//arg0: [string] Maske (siehe file_find_first)
//arg1: [real]   Attribute (siehe file_find_first auer fa_volumeid)
if (!global.hConnection)
{
    show_error("keine aktive FTP-Verbindung",false);
    return false;
}

return external_call(global.ftp_findfirst,global.hConnection,argument0,argument1);


#define ftp_file_find_next
//Gibt den Namen der nchsten gefundenen Datei zurck
//keine Argumente

if (!global.hConnection)
{
    show_error("keine aktive FTP-Verbindung",false);
    return false;
}

return external_call(global.ftp_findnext);

#define ftp_file_find_close
//Beendet Dateiauflistung
external_call(global.ftp_closefind);

#define ftp_file_rename
//Benennt eine Datei auf dem Server um; Erfolgsmeldung
//arg0: [string] Dateiname
//arg1: [string] neuer Name

if (!global.hConnection)
{
    show_error("keine aktive FTP-Verbindung",false);
    return false;
}

return external_call(global.ftp_rename,global.hConnection,argument0,argument1);

#define ftp_file_delete
//Lscht eine Datei auf dem Server; Erfolgsmeldung
//arg0: [string] Dateiname

if (!global.hConnection)
{
    show_error("keine aktive FTP-Verbindung",false);
    return false;
}

return external_call(global.ftp_delete,global.hConnection,argument0);
