#define RMS_Ini
//initialisiert das RMS System fr die Benutzung,
//Achtung, dieses Skript muss nicht fr die Erzeugung
//der Ressourcenstruktur aufgerufen werden.
//argument0 gibt hier den Namen der Ini Datei an, die benutzt wird,
//argument1 den Namen des Ressourcenverzeichnisses (standart ist RMSFiles\)


var i,str,errorstring;
errorstring="";
globalvar RMS_sprcounter,RMS_sndcounter,RMS_backcounter,RMS_pthcounter,RMS_tlcounter,RMS_objcounter,RMS_rmcounter,RMS_spr,RMS_snd,RMS_back,RMS_pth,RMS_tl,RMS_obj,RMS_rm;
globalvar RMS_sprpath,RMS_sndpath,RMS_backpath,RMS_pthpath,RMS_tlpath,RMS_objpath,RMS_rmpath;
RMS_sprpath=argument1+"Sprites\";
RMS_sndpath=argument1+"Sounds\";
RMS_backpath=argument1+"Backgrounds\";
RMS_pthpath=argument1+"Paths\";
RMS_tlpath=argument1+"Timelines\";
RMS_objpath=argument1+"Objects\";
RMS_rmpath=argument1+"Rooms\";

ini_open(argument0+".ini");
RMS_sprcounter=0;  //Sprites
if (ini_section_exists("Sprites")){
    for (i=0;ini_key_exists("Sprites",string(i));i+=1){
        str=ini_read_string("Sprites",string(i),"");
        variable_global_set(str,i);    
        RMS_spr[i]=ds_list_create();
        ds_list_add(RMS_spr[i],str+".sprite"); 
        ds_list_add(RMS_spr[i],noone);        
        RMS_sprcounter+=1;
    }
}
else{
    errorstring+=" - Sprite Sektion nicht gefunden";
}

RMS_sndcounter=0;  //Sounds
if (ini_section_exists("Sounds")){
    for (i=0;ini_key_exists("Sounds",string(i));i+=1){
        str=ini_read_string("Sounds",string(i),"");
        variable_global_set(str,i+RMS_sprcounter);    
        RMS_snd[i]=ds_list_create();
        ds_list_add(RMS_snd[i],str+".sound"); 
        ds_list_add(RMS_snd[i],noone);        
        RMS_sndcounter+=1;
    }
}
else{
    errorstring+=" - Sound Sektion nicht gefunden";
}

RMS_backcounter=0;  //Backgrounds
if (ini_section_exists("Backgrounds")){
    for (i=0;ini_key_exists("Backgrounds",string(i));i+=1){
        str=ini_read_string("Backgrounds",string(i),"");
        variable_global_set(str,i+RMS_sprcounter+RMS_sndcounter);    
        RMS_back[i]=ds_list_create();
        ds_list_add(RMS_back[i],str+".back"); 
        ds_list_add(RMS_back[i],noone);        
        RMS_backcounter+=1;
    }
}
else{
    errorstring+=" - Background Sektion nicht gefunden";
}

RMS_pthcounter=0;  //Paths
if (ini_section_exists("Paths")){
    for (i=0;ini_key_exists("Paths",string(i));i+=1){
        str=ini_read_string("Paths",string(i),"");
        variable_global_set(str,i+RMS_sprcounter+RMS_sndcounter+RMS_backcounter);    
        RMS_pth[i]=ds_list_create();
        ds_list_add(RMS_pth[i],str+".path"); 
        ds_list_add(RMS_pth[i],noone);        
        RMS_pthcounter+=1;
    }
}
else{
    errorstring+=" - Path Sektion nicht gefunden";
}

RMS_tlcounter=0;  //Timelines
if (ini_section_exists("Timelines")){
    for (i=0;ini_key_exists("Timelines",string(i));i+=1){
        str=ini_read_string("Timelines",string(i),"");
        variable_global_set(str,i+RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter);    
        RMS_tl[i]=ds_list_create();
        ds_list_add(RMS_tl[i],str+".timeline"); 
        ds_list_add(RMS_tl[i],noone);        
        RMS_tlcounter+=1;
    }
}
else{
    errorstring+=" - Timeline Sektion nicht gefunden";
}
RMS_objcounter=0;  //Objects
if (ini_section_exists("Objects")){
    for (i=0;ini_key_exists("Objects",string(i));i+=1){
        str=ini_read_string("Objects",string(i),"");
        variable_global_set(str,i+RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter);    
        RMS_obj[i]=ds_list_create();
        ds_list_add(RMS_obj[i],str+".object"); 
        ds_list_add(RMS_obj[i],noone);        
        RMS_objcounter+=1;
    }
}
else{
    errorstring+=" - Object Sektion nicht gefunden";
}
RMS_rmcounter=0;  //Rooms
if (ini_section_exists("Rooms")){
    for (i=0;ini_key_exists("Rooms",string(i));i+=1){
        str=ini_read_string("Rooms",string(i),"");
        variable_global_set(str,i+RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter+RMS_objcounter);    
        RMS_rm[i]=ds_list_create();
        ds_list_add(RMS_rm[i],str+".room"); 
        ds_list_add(RMS_rm[i],noone);        
        RMS_rmcounter+=1;
    }
}
else{
    errorstring+=" - Room Sektion nicht gefunden";
}

return errorstring;


#define RMS_CreateList
//Muss im ersten Raum aufgerufen werden
//erzeugt eine ini Datei, in der alle Sprites,Sounds,Backgrounds und Paths
//eingebunden sind.
//Weiterhin wird ein Unterverzeichnis RMSFiles erzeugt, in dem die Informationsdateien
//zu den Ressourcen abgelegt werden. 
//In die jeweiligen Ordner mssen bei Sprites, Sounds und Backgrounds auch noch die entsprechenden
//Ressourcen kopiert werden. Sie erhalten den Namen wie die zugehrige Info Datei plus die Endung
//.gif (Backgrounds,Sprites) bzw .music (Sounds).
//argument0=Dateiname
//argument1=Sprites speichern
//argument2=Sounds speichern
//argument3=Backgrounds speichern
//argument4=Paths speichern
//argument5=Timelines speichern
//argument6=Objects speichern
//argument7=Rooms speichern (Ohne Tiles)

if (file_exists(argument0+".ini")){
    file_delete(argument0+".ini");
}
ini_open(argument0+".ini");

var i,j,cnt;

if (!directory_exists(working_directory+"\RMSFiles\")){
    directory_create(working_directory+"\RMSFiles\");
}
if (!directory_exists(working_directory+"\RMSFiles\Sprites\")){
    directory_create(working_directory+"\RMSFiles\Sprites\");
}
if (!directory_exists(working_directory+"\RMSFiles\Sounds\")){
    directory_create(working_directory+"\RMSFiles\Sounds\");
}
if (!directory_exists(working_directory+"\RMSFiles\Backgrounds\")){
    directory_create(working_directory+"\RMSFiles\Backgrounds\");
}
if (!directory_exists(working_directory+"\RMSFiles\Paths\")){
    directory_create(working_directory+"\RMSFiles\Paths\");
}
if (!directory_exists(working_directory+"\RMSFiles\Timelines\")){
    directory_create(working_directory+"\RMSFiles\Timelines\");
}
if (!directory_exists(working_directory+"\RMSFiles\Objects\")){
    directory_create(working_directory+"\RMSFiles\Objects\");
}
if (!directory_exists(working_directory+"\RMSFiles\Timelines\")){
    directory_create(working_directory+"\RMSFiles\Timelines\");
}
if (!directory_exists(working_directory+"\RMSFiles\Rooms\")){
    directory_create(working_directory+"\RMSFiles\Rooms\");
}



if (argument1){ //Sprites
    j=0;
    cnt=0;
    for (i=0;j<10;i+=1){
        if (sprite_exists(i)){
            j=0;
            ini_write_string("Sprites",string(cnt),sprite_name(i));
            RMS_SaveSprite(i,"RMSFiles\Sprites\"+sprite_name(i)+".sprite");
            cnt+=1;
        }
        else{
            j+=1;
        }
    }
}
if (argument2){ //Sounds
    j=0;
    cnt=0;
    for (i=0;j<10;i+=1){
        if (sound_exists(i)){
            j=0;
            ini_write_string("Sounds",string(cnt),sound_name(i));
            RMS_SaveSound(i,"RMSFiles\Sounds\"+sound_name(i)+".sound");
            cnt+=1;
        }
        else{
            j+=1;
        }
    }
}
if (argument3){ //Backgrounds
    j=0;
    cnt=0;
    for (i=0;j<10;i+=1){
        if (background_exists(i)){
            j=0;
            ini_write_string("Backgrounds",string(cnt),background_name(i));
            RMS_SaveBackground(i,"RMSFiles\Backgrounds\"+background_name(i)+".back");
            cnt+=1;
        }
        else{
            j+=1;
        }
    }
}
if (argument4){ //Paths
    j=0;
    cnt=0;
    for (i=0;j<10;i+=1){
        if (path_exists(i)){
            j=0;
            ini_write_string("Paths",string(cnt),path_name(i));
            RMS_SavePath(i,"RMSFiles\Paths\"+path_name(i)+".path");
            cnt+=1;
        }
        else{
            j+=1;
        }
    }
}
if (argument5){ //Timelines Anmerkung: Platzhalter, da ber Timelines keine richtigen Infos gespeichert werden
    j=0;
    cnt=0;
    for (i=0;j<10;i+=1){
        if (timeline_exists(i)){
            j=0;
            ini_write_string("Timelines",string(cnt),timeline_name(i));
            RMS_SaveTimeline(i,"RMSFiles\Timelines\"+timeline_name(i)+".timeline");
            cnt+=1;
        }
        else{
            j+=1;
        }
    }
}
if (argument6){ //Objects
    j=0;
    cnt=0;
    for (i=0;j<10;i+=1){
        if (object_exists(i)){
            j=0;
            ini_write_string("Objects",string(cnt),object_name(i));
            RMS_SaveObject(i,"RMSFiles\Objects\"+object_name(i)+".object");
            cnt+=1;
        }
        else{
            j+=1;
        }
    }
}
if (argument7){ //Rooms
    j=0;
    global.cnt=0;
    froom=true;
    ranf=0;
    ini_write_string("Rooms",string(global.cnt),room_name(room));
    RMS_SaveRoom(room,"RMSFiles\Rooms\"+room_name(room)+".room");
    
    
    
    
    
    
    
    
    /*for (i=0;j<10;i+=1){
        if (room_exists(i)){
            j=0;
            if (froom){
                ranf=i;
                ini_write_string("Rooms",string(cnt),room_name(i));
                
                froom=false;                
            }
            else{
                ini_write_string("Rooms",string(cnt),room_name(i));
                room_set_code(i,"RSM_SaveRoom(room,'RMSFiles\Rooms\'+room_name(room)+'.room')");
            } 
            cnt+=1;
        }
        else{
            j+=1;
        }
    }
     //dann in den ersten room gehen
    RMS_SaveRoom(ranf,"RMSFiles\Rooms\"+room_name(ranf)+".room");*/
}

//ini_close();
#define RMS_Get
//gibt den Index der gewnschten Ressource argument0 zurck
var ind,di;
ind=argument0;
if (ind>=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter+RMS_objcounter)){ //Room
    ind-=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter+RMS_objcounter);
    if (ds_list_size(RMS_rm[ind])<=2){ //Timeline muss komplett neu geladen werden
        di=RMS_LoadRoom(RMS_rmpath+ds_list_find_value(RMS_rm[ind],0));
        ds_list_replace(RMS_rm[ind],1,di);
    }
    else{
        //Den Room trotz allem neu mit Objekten usw bestcken
        RMS_LoadExRoom(RMS_rmpath+ds_list_find_value(RMS_rm[ind],0),ds_list_find_value(RMS_rm[ind],1));
    }
    ds_list_add(RMS_rm[ind],0); //Das aktuelle Objekt als Benutzer eintragen
    return ds_list_find_value(RMS_rm[ind],1);
}
else if (ind>=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter)){ //Object
    ind-=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter);
    if (ds_list_size(RMS_obj[ind])<=2){ //Timeline muss komplett neu geladen werden
        di=RMS_LoadObject(RMS_objpath+ds_list_find_value(RMS_obj[ind],0));
        ds_list_replace(RMS_obj[ind],1,di);
    }
    ds_list_add(RMS_obj[ind],0); //Das aktuelle Objekt als Benutzer eintragen
    return ds_list_find_value(RMS_obj[ind],1);
}
else if (ind>=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter)){ //Timeline
    ind-=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter);
    if (ds_list_size(RMS_tl[ind])<=2){ //Timeline muss komplett neu geladen werden
        di=RMS_LoadTimeline(RMS_tlpath+ds_list_find_value(RMS_tl[ind],0));
        ds_list_replace(RMS_tl[ind],1,di);
    }
    ds_list_add(RMS_tl[ind],0); //Das aktuelle Objekt als Benutzer eintragen
    return ds_list_find_value(RMS_tl[ind],1);
}
else if (ind>=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter)){ //Path
    ind-=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter);
    if (ds_list_size(RMS_pth[ind])<=2){ //Path muss komplett neu geladen werden
        di=RMS_LoadPath(RMS_pthpath+ds_list_find_value(RMS_pth[ind],0));
        ds_list_replace(RMS_pth[ind],1,di);
    }
    ds_list_add(RMS_pth[ind],0); //Das aktuelle Objekt als Benutzer eintragen
    return ds_list_find_value(RMS_pth[ind],1);
}
else if (ind>=(RMS_sprcounter+RMS_sndcounter)){ //Background
    ind-=(RMS_sprcounter+RMS_sndcounter); 
    if (ds_list_size(RMS_back[ind])<=2){ //Background muss komplett neu geladen werden
        di=RMS_LoadBackground(RMS_backpath+ds_list_find_value(RMS_back[ind],0));
        ds_list_replace(RMS_back[ind],1,di);
    }
    ds_list_add(RMS_back[ind],0); //Das aktuelle Objekt als Benutzer eintragen
    return ds_list_find_value(RMS_back[ind],1);
}
else if (ind>=RMS_sprcounter){ //Sound
    ind-=(RMS_sprcounter);
    if (ds_list_size(RMS_snd[ind])<=2){ //Sound muss komplett neu geladen werden
        di=RMS_LoadSound(RMS_sndpath+ds_list_find_value(RMS_snd[ind],0));
        ds_list_replace(RMS_snd[ind],1,di);
    }
    ds_list_add(RMS_snd[ind],0); //Das aktuelle Objekt als Benutzer eintragen
    return ds_list_find_value(RMS_snd[ind],1);
}
else{ //Sprite
    ind=ind;
    if (ds_list_size(RMS_spr[ind])<=2){ //Sprite muss komplett neu geladen werden
        di=RMS_LoadSprite(RMS_sprpath+ds_list_find_value(RMS_spr[ind],0));
        ds_list_replace(RMS_spr[ind],1,di);
    }
    ds_list_add(RMS_spr[ind],0); //Das aktuelle Objekt als Benutzer eintragen
    return ds_list_find_value(RMS_spr[ind],1);
}
#define RMS_Drop
//trgt das aktuelle Objekt als Nutzer der Ressource argument0 aus und lscht diese aus
//dem Speicher, falls es der letzte Nutzer war.
//argument1 ist der Benutzerstring, ist er leer, wird object angenommen.
//fr genaueres siehe RMS_Get
var ind,di,val,pos;
ind=argument0;
if (is_string(argument1)){
    val=argument1;
}
else{
    val="Object:"+string(id);
}
if (ind>=RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter+RMS_objcounter){ //Rooms
    ind-=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter+RMS_objcounter);
    pos=ds_list_find_index(RMS_rm[ind],val);
    if (pos!=-1){
        ds_list_delete(RMS_rm[ind],pos); //austragen
    } 
    //if (ds_list_size(rm[ind])<=2){   //wenn keine Nutzer mehr brig, lschen
    //    path_delete(ds_list_find_value(rm[ind],1));
    //    ds_list_replace(rm[ind],1,noone);
    //}
}
else if (ind>=RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter){ //Objects
    ind-=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter);
    pos=ds_list_find_index(RMS_obj[ind],val);
    if (pos!=-1){
        ds_list_delete(RMS_obj[ind],pos); //austragen
    } 
    if (ds_list_size(RMS_obj[ind])<=2){   //wenn keine Nutzer mehr brig, lschen
        path_delete(ds_list_find_value(RMS_obj[ind],1));
        ds_list_replace(RMS_obj[ind],1,noone);
    }
}
else if (ind>=RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter){ //Timeline
    ind-=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter);
    pos=ds_list_find_index(RMS_tl[ind],val);
    if (pos!=-1){
        ds_list_delete(RMS_tl[ind],pos); //austragen
    } 
    if (ds_list_size(RMS_tl[ind])<=2){   //wenn keine Nutzer mehr brig, lschen
        path_delete(ds_list_find_value(RMS_tl[ind],1));
        ds_list_replace(RMS_tl[ind],1,noone);
    }
}
else if (ind>=RMS_sprcounter+RMS_sndcounter+RMS_backcounter){ //Path
    ind-=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter);
    pos=ds_list_find_index(RMS_pth[ind],val);
    if (pos!=-1){
        ds_list_delete(RMS_pth[ind],pos); //austragen
    } 
    if (ds_list_size(RMS_pth[ind])<=2){   //wenn keine Nutzer mehr brig, lschen
        path_delete(ds_list_find_value(RMS_pth[ind],1));
        ds_list_replace(RMS_pth[ind],1,noone);
    }
}
else if (ind>=RMS_sprcounter+RMS_sndcounter){ //Background
    ind-=(RMS_sprcounter+RMS_sndcounter);
    pos=ds_list_find_index(RMS_back[ind],val);
    if (pos!=-1){
        ds_list_delete(RMS_back[ind],pos); //austragen
    } 
    if (ds_list_size(RMS_back[ind])<=2){   //wenn keine Nutzer mehr brig, lschen
        background_delete(ds_list_find_value(RMS_back[ind],1));
        ds_list_replace(RMS_back[ind],1,noone);
    }
}
else if (ind>=RMS_sprcounter){ //Sound
    ind-=(RMS_sprcounter);
    pos=ds_list_find_index(RMS_snd[ind],val);
    if (pos!=-1){
        ds_list_delete(RMS_snd[ind],pos); //austragen
    } 
    if (ds_list_size(RMS_snd[ind])<=2){   //wenn keine Nutzer mehr brig, lschen
        sound_delete(ds_list_find_value(RMS_snd[ind],1));
        ds_list_replace(RMS_snd[ind],1,noone);
    }
}
else{ //Sprite
    ind=ind;
    pos=ds_list_find_index(RMS_spr[ind],val);
    if (pos!=-1){
        ds_list_delete(RMS_spr[ind],pos); //austragen
    } 
    if (ds_list_size(RMS_spr[ind])<=2){   //wenn keine Nutzer mehr brig, lschen
        sprite_delete(ds_list_find_value(RMS_spr[ind],1));
        ds_list_replace(RMS_spr[ind],1,noone);
    }
}
#define RMS_Free
//stoppt das RMS und lscht alle von diesem geladenen Dateien aus
//dem Speicher.
//Warnung: Rufe dieses Skript nur dann auf, wenn keine mit RMS geladenen
//Ressourcen mehr im Spiel benutzt werden.
//Dieses Skript muss nicht unbedingt aufgerufen werden, da alle geladenen
//Ressourcen mit Spielende sowieso aus dem Speicher gelscht werden

//Sprites lschen
for (i=0;i<RMS_sprcounter;i+=1){
    if (ds_list_size(RMS_spr[i])>2){
        sprite_delete(ds_list_find_value(RMS_spr[i],1));
    }
}
//Sounds lschen
for (i=0;i<RMS_sndcounter;i+=1){
    if (ds_list_size(RMS_snd[i])>2){
        sound_delete(ds_list_find_value(RMS_snd[i],1));
    }
}
//Backgrounds lschen
for (i=0;i<RMS_backcounter;i+=1){
    if (ds_list_size(RMS_back[i])>2){
        background_delete(ds_list_find_value(RMS_back[i],1));
    }
}
//Paths lschen
for (i=0;i<RMS_pthcounter;i+=1){
    if (ds_list_size(RMS_pth[i])>2){
        path_delete(ds_list_find_value(RMS_pth[i],1));
    }
}
//Timelines lschen
for (i=0;i<RMS_tlcounter;i+=1){
    if (ds_list_size(RMS_tl[i])>2){
        timeline_delete(ds_list_find_value(RMS_tl[i],1));
    }
}
//Objects lschen
for (i=0;i<RMS_objcounter;i+=1){
    if (ds_list_size(RMS_obj[i])>2){
        object_delete(ds_list_find_value(RMS_obj[i],1));
    }
}
//Rooms lschen
/*for (i=0;i<RMS_rmcounter;i+=1){
    if (ds_list_size(RMS_rm[i])>2){
        object_delete(ds_list_find_value(RMS_rm[i],1));
    }
}*/

//ds Listen lschen
ds_list_clear(RMS_spr);
ds_list_clear(RMS_snd);
ds_list_clear(RMS_back);
ds_list_clear(RMS_pth);
ds_list_clear(RMS_tl);
ds_list_clear(RMS_obj);
ds_list_clear(RMS_rm);
#define RMS_Index
//Gibt den Index der Ressource argument0 zurck
//Achtung: Diese Funktion sollte nur zu Vergleichszwecken benutzt werden
//und NICHT zum zuweisen. Sonst kann es sein, dass eine noch bentigte
//Ressource gelscht wird.
var ind;
ind=argument0;
if (ind>=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter+RMS_objcounter)){ //Rooms
    ind-=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter+RMS_objcounter);
    ind=ds_list_find_value(RMS_rm[ind],1);
}
else if (ind>=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter)){ //Object
    ind-=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter+RMS_tlcounter);
    ind=ds_list_find_value(RMS_obj[ind],1);
}
else if (ind>=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter)){ //Timeline
    ind-=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter+RMS_pthcounter);
    ind=ds_list_find_value(RMS_tl[ind],1);
}
else if (ind>=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter)){ //Path
    ind-=(RMS_sprcounter+RMS_sndcounter+RMS_backcounter);
    ind=ds_list_find_value(RMS_pth[ind],1);
}
else if (ind>=(RMS_sprcounter+RMS_sndcounter)){ //Background
    ind-=(RMS_sprcounter+RMS_sndcounter);
    ind=ds_list_find_value(RMS_back[ind],1);
}
else if (ind>=RMS_sprcounter){ //Sound
    ind-=(RMS_sprcounter);
    ind=ds_list_find_value(RMS_snd[ind],1);
}
else{ //Sprite
    ind=ind;
    ind=ds_list_find_value(RMS_spr[ind],1);
}
return ind;
#define RMS_Clean
//Bereinigt den Arbeitsspeicher, indem es fr jede
//verwaltete Ressource anhand der jeweiligen Benutzerliste
//berprft, ob sie noch gebraucht wird.
//Achtung: Sollte bei verwalteten Sounds nicht im Step Event aufgerufen werden,
//da sound_isplaying eine Verzgerungszeit hat

//1. Sprites
var i,j,ds,str,ustype,user,strpos;
for (i=0;i<RMS_sprcounter;i+=1){
    ds=RMS_spr[i];
    if (ds_list_size(ds)>2){
        for (j=ds_list_size(ds)-1;j>1;j-=1){
            str=ds_list_find_value(ds,j);
            strpos=string_pos(":",str);
            ustype=string_copy(str,1,strpos-1);
            user=real(string_copy(str,strpos+1,string_length(str)-strpos));
            if ((ustype=="Object")||(ustype=="object")){
                if (!instance_exists(user)){
                    ds_list_delete(ds,j);
                }
            }
            else{
                if (room!=user){
                    ds_list_delete(ds,j);
                }
            }
        }
        if (ds_list_size(ds)<=2){   //wenn keine Nutzer mehr brig, lschen
            sprite_delete(ds_list_find_value(ds,1));
            ds_list_replace(ds,1,noone);
        }
    }
}

//2. Sounds
var i,j,ds,str,ustype,user,strpos;
for (i=0;i<RMS_sndcounter;i+=1){
    ds=RMS_snd[i];
    if (ds_list_size(ds)>2){
        for (j=ds_list_size(ds)-1;j>1;j-=1){
            str=ds_list_find_value(ds,j);
            strpos=string_pos(":",str);
            ustype=string_copy(str,1,strpos-1);
            user=real(string_copy(str,strpos+1,string_length(str)-strpos));
            if (!sound_isplaying(ds_list_find_value(ds,1))){
                ds_list_delete(ds,j);
            }
        }
        if (ds_list_size(ds)<=2){   //wenn keine Nutzer mehr brig, lschen
            sound_delete(ds_list_find_value(ds,1));
            ds_list_replace(ds,1,noone);
        }
    }
}

//3. Backgrounds
var i,j,ds,str,ustype,user,strpos;
for (i=0;i<RMS_backcounter;i+=1){
    ds=RMS_back[i];
    if (ds_list_size(ds)>2){
        for (j=ds_list_size(ds)-1;j>1;j-=1){
            str=ds_list_find_value(ds,j);
            strpos=string_pos(":",str);
            ustype=string_copy(str,1,strpos-1);
            user=real(string_copy(str,strpos+1,string_length(str)-strpos));
            if ((ustype=="Object")||(ustype=="object")){
                if (!instance_exists(user)){
                    ds_list_delete(ds,j);
                }
            }
            else{
                if (room!=user){
                    ds_list_delete(ds,j);
                }
            }
        }
        if (ds_list_size(ds)<=2){   //wenn keine Nutzer mehr brig, lschen
            background_delete(ds_list_find_value(ds,1));
            ds_list_replace(ds,1,noone);
        }
    }
}

//4. Paths
var i,j,ds,str,ustype,user,strpos;
for (i=0;i<RMS_pthcounter;i+=1){
    ds=RMS_pth[i];
    if (ds_list_size(ds)>2){
        for (j=ds_list_size(ds)-1;j>1;j-=1){
            str=ds_list_find_value(ds,j);
            strpos=string_pos(":",str);
            ustype=string_copy(str,1,strpos-1);
            user=real(string_copy(str,strpos+1,string_length(str)-strpos));
            if ((ustype=="Object")||(ustype=="object")){
                if (!instance_exists(user)){
                    ds_list_delete(ds,j);
                }
            }
        }
        if (ds_list_size(ds)<=2){   //wenn keine Nutzer mehr brig, lschen
            path_delete(ds_list_find_value(ds,1));
            ds_list_replace(ds,1,noone);
        }
    }
}

//5. Timelines
var i,j,ds,str,ustype,user,strpos;
for (i=0;i<RMS_tlcounter;i+=1){
    ds=RMS_tl[i];
    if (ds_list_size(ds)>2){
        for (j=ds_list_size(ds)-1;j>1;j-=1){
            str=ds_list_find_value(ds,j);
            strpos=string_pos(":",str);
            ustype=string_copy(str,1,strpos-1);
            user=real(string_copy(str,strpos+1,string_length(str)-strpos));
            if ((ustype=="Object")||(ustype=="object")){
                if (!instance_exists(user)){
                    ds_list_delete(ds,j);
                }
            }
        }
        if (ds_list_size(ds)<=2){   //wenn keine Nutzer mehr brig, lschen
            timeline_delete(ds_list_find_value(ds,1));
            ds_list_replace(ds,1,noone);
        }
    }
}

//6. Objects
var i,j,ds,str,ustype,user,strpos,nodel;
nodel=false;
while(!nodel){
    nodel=true;
    for (i=0;i<RMS_objcounter;i+=1){
        ds=RMS_obj[i];
        if (ds_list_size(ds)>2){
            for (j=ds_list_size(ds)-1;j>1;j-=1){
                str=ds_list_find_value(ds,j);
                strpos=string_pos(":",str);
                ustype=string_copy(str,1,strpos-1);
                user=real(string_copy(str,strpos+1,string_length(str)-strpos));
                if ((ustype=="Object")||(ustype=="object")){
                    if (!instance_exists(user)){
                        ds_list_delete(ds,j);
                    }
                }
                else{
                    if (room!=user){
                        ds_list_delete(ds,j);
                    }
                }
            }
            if (ds_list_size(ds)<=2){   //wenn keine Nutzer mehr brig, lschen
                object_delete(ds_list_find_value(ds,1));
                ds_list_replace(ds,1,noone);
                nodel=false;
            }
        }
    }
}

//7. Rooms
var i,j,ds,str,ustype,user,strpos;
for (i=0;i<RMS_rmcounter;i+=1){
    ds=RMS_rm[i];
    if (ds_list_size(ds)>2){
        for (j=ds_list_size(ds)-1;j>1;j-=1){
            str=ds_list_find_value(ds,j);
            strpos=string_pos(":",str);
            ustype=string_copy(str,1,strpos-1);
            user=real(string_copy(str,strpos+1,string_length(str)-strpos));
            if (room!=ds_list_find_value(ds,1)){
                ds_list_delete(ds,j);
            }
        }
        //if (ds_list_size(ds)<=2){   //wenn keine Nutzer mehr brig, lschen
        //    room_delete(ds_list_find_value(ds,1));
        //    ds_list_replace(ds,1,noone);
        //}
    }
}
#define RMS_SaveSprite
//sichert das Sprite mit dem Index argument0 in die Datei argument1
//allerdings muss die Grafik selber noch extra (unter demselben Namen blo
//.gif gespeichert werden.

var ind,fhandle;
ind=argument0;
fhandle=file_text_open_write(argument1);
file_text_write_string(fhandle,string(sprite_get_transparent(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(sprite_get_smooth(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(sprite_get_preload(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(sprite_get_xoffset(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(sprite_get_yoffset(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(sprite_get_bbox_left(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(sprite_get_bbox_right(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(sprite_get_bbox_top(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(sprite_get_bbox_bottom(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(sprite_get_bbox_mode(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(sprite_get_precise(ind)));
file_text_close(fhandle);
#define RMS_LoadSprite
//Ldt das Sprite aus der Datei argument0 und gibt den Index zurck
//die entsprechende gif Datei muss den Namen argument0+.gif haben
var fhandle,prec,trans,smooth,prel,xori,yori,bbleft,bbright,bbtop,bbbottom,bbmode,ind;
fhandle=file_text_open_read(argument0);
trans=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
smooth=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
prel=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
xori=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
yori=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
bbleft=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
bbright=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
bbtop=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
bbbottom=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
bbmode=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
prec=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
ind=sprite_add(argument0+".gif",0,prec,trans,smooth,prel,xori,yori);
sprite_set_bbox(ind,bbleft,bbtop,bbright,bbbottom);
sprite_set_bbox_mode(ind,bbmode);
file_text_close(fhandle);

return ind;
#define RMS_SaveSound
//speichert den Sound mit Index argument0 in die Datei argument1
var fhandle;
fhandle=file_text_open_write(argument1);
file_text_write_string(fhandle,string(sound_get_kind(argument0)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(sound_get_preload(argument0)));
file_text_close(fhandle);


#define RMS_LoadSound
//ldt einen Sound aus der Datei argument0 
//(eigentlicher Sound muss argument0+".music" heien)
//und gibt den Index zurck
var fhandle,kind,prel,ind;
fhandle=file_text_open_read(argument0);
kind=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
prel=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
file_text_close(fhandle);
ind=sound_add(argument0+".music",kind,prel);
return ind;

#define RMS_SaveBackground
//speichert die Informationen ber den Background mit dem Index argument0
//in die Datei argument1
var fhandle;
fhandle=file_text_open_write(argument1);
file_text_write_string(fhandle,string(background_get_transparent(argument0)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(background_get_smooth(argument0)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(background_get_preload(argument0)));
file_text_close(fhandle);
#define RMS_LoadBackground
//Ldt einen Background aus den Informationen in der Datei argument0 und
//dem Bild argument0+.gif
var fhandle,trans,smooth,prel,ind;
fhandle=file_text_open_read(argument0);
trans=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
smooth=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
prel=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
file_text_close(fhandle);
ind=background_add(argument0+".bmp",trans,smooth,prel);
return ind;
#define RMS_SavePath
//speichert den Path mit dem Index argument0 in die Datei argument1

var fhandle,xold,yold,xn,yn,len,i,pos;
fhandle=file_text_open_write(argument1);

//zuerst die allgemeinen Pathinfos
file_text_write_string(fhandle,string(path_get_kind(argument0)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(path_get_closed(argument0)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(path_get_precision(argument0)));

//dann die einzelnen Punkte
xold=noone;
yold=noone;
xn=noone;
yn=noone;
len=0;
for (i=0;i<path_get_number(argument0);i+=1){
    xn=path_get_point_x(argument0,i);
    yn=path_get_point_y(argument0,i);
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(xn));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(yn));
    if (xold==noone)&&(yold==noone){
        pos=0;
    }
    else{
        len=len+point_distance(xold,yold,xn,yn);
        pos=path_get_length(argument0)/len;
    }
    xold=xn;
    yold=yn;
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(path_get_speed(argument0,pos)));
}
file_text_close(fhandle);
#define RMS_LoadPath
//ldt einen Pfad aus der Datei argument0 und gibt den Index des neu erzeugten Paths zurck
if (file_exists(argument0)){
fhandle=file_text_open_read(argument0);
ind=path_add();

path_set_kind(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
path_set_closed(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
path_set_precision(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);

for (i=0;(file_text_eof(fhandle)!=true);i+=1){
    xn=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    yn=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    sp=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    path_add_point(ind,xn,yn,sp);
}
return ind;
}
else{
    return noone;
}
#define RMS_SaveTimeline
//sichert die Informationen ber die Timeline mit Index argument0 
//in die Datei argument1. Die eigentlichen Timelinecodes mssen
//aber extra in einer Datei der Form
//[moment]
//code
//code
//code
//[moment]
//code
//...
//und der Endung .timeline gespeichert werden



//Anmerkung: Dieses Skript ist nur ein Platzhalter und kann eigentlich gelscht werden.
//Es wurde nur aus Stilgrnden aufgenommen
#define RMS_LoadTimeline
//Ldt eine Time Line aus der Datei argument0 und gibt den Index zurck
var fhandle,str,s,i,ind;
fhandle=file_text_open_read(argument0);
i=-1;
str="";
ind=timeline_add();
while(file_text_eof(fhandle)==false){
    s=file_text_read_string(fhandle);
    if (string_copy(s,1,1)=="["){
        if (i!=-1){
            timeline_moment_add(ind,i,str);
            i=real(string_copy(s,2,string_length(s)-2));
            str="";
        }
        else{
            i=real(string_copy(s,2,string_length(s)-2));
            str="";
        }
    }
    else{
        str+=s;
    }
    file_text_readln(fhandle);
}
if (str!=""){
    timeline_moment_add(ind,i,str);
}

file_text_close(fhandle);
return ind;
#define RMS_SaveObject
//Sichert die Informationen ber ein Objekt mit Index argument0 in der Datei argument1
//die Codes mssen in eine extra datei mit dem namen des Objektes+.object+.code
//mit dem Aufbau
//[Eventname$Eventnummer]
//Code
//[Eventname$Eventnummer]
//Code
//Code
//...
//Die Eventnamen und Eventnummern stehen in der Hilfe unter event_perform()
var fhandle,ind;
ind=argument0;
fhandle=file_text_open_write(argument1);
file_text_write_string(fhandle,sprite_name(object_get_sprite(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(object_get_sprite(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(object_get_solid(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(object_get_visible(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(object_get_depth(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(object_get_persistent(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,sprite_name(object_get_mask(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(object_get_mask(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,object_name(object_get_parent(ind)));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(object_get_parent(ind)));
file_text_close(fhandle);
#define RMS_LoadObject
//ldt ein Objekt aus der Datei argument0 und argument0+.code
//darf erst aufgerufen werden, wenn das RMS initialisiert wurde,
//da es hier bereits benutzt wird. Gibt den Index des Objektes zurck
var fhandle,ind,sprverw,maskverw,parverw,i,s,str;
var spr,mask,par;
sprverw=false;
maskverw=false;
parverw=false;
ind=object_add();
fhandle=file_text_open_read(argument0);
spr=file_text_read_string(fhandle);
file_text_readln(fhandle);
if (variable_global_exists(spr)){
    //verwaltete Ressource
    object_set_sprite(ind,RMS_Get(variable_global_get(spr),"Object:"+string(ind)));
    sprverw=true;
    file_text_readln(fhandle);
}
else{
    object_set_sprite(ind,real(file_text_read_string(fhandle)));
    file_text_readln(fhandle);
}
object_set_solid(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
object_set_visible(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
object_set_depth(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
object_set_persistent(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
mask=file_text_read_string(fhandle);
file_text_readln(fhandle);
if (variable_global_exists(mask)){
    //verwaltete Ressource
    object_set_mask(ind,RMS_Get(variable_global_get(mask),"Object:"+string(ind)));
    maskverw=true;
    file_text_readln(fhandle);
}
else{
    object_set_mask(ind,real(file_text_read_string(fhandle)));
    file_text_readln(fhandle);
}
par=file_text_read_string(fhandle);
file_text_readln(fhandle);
if (variable_global_exists(par)){
    //verwaltete Ressource
    object_set_parent(ind,RMS_Get(variable_global_get(par),"Object:"+string(ind)));
    parverw=true;
    file_text_readln(fhandle);
}
else{
    object_set_parent(ind,real(file_text_read_string(fhandle)));
    file_text_readln(fhandle);
}
file_text_close(fhandle);

i="";
s="";
str="";

 //Events einlesen
fhandle=file_text_open_read(argument0+".code");

while(file_text_eof(fhandle)==false){
    s=file_text_read_string(fhandle);
    if (string_copy(s,1,1)=="["){
        if (i!=""){
            RMS_ObjectEventAdd(ind,i,str);
            i=string_copy(s,2,string_length(s)-2);
            str="";
        }
        else{
            i=string_copy(s,2,string_length(s)-2);
            str="";
        }
    }
    else{
        str+=s;
    }
    file_text_readln(fhandle);
}
if (str!=""){
    RMS_ObjectEventAdd(ind,i,str);
}



 //wenn mask, sprite oder parent verwaltet sind, dann ins destroy event noch was hinzufgen
if (sprverw){
    RMS_ObjectEventAdd(ind,"ev_destroy$noone","RMS_Drop(global."+spr+")");
}
if (maskverw){
    RMS_ObjectEventAdd(ind,"ev_destroy$noone","RMS_Drop(global."+mask+")");
}
if (parverw){
    RMS_ObjectEventAdd(ind,"ev_destroy$noone","RMS_Drop(global."+par+")");
}

file_text_close(fhandle);

return ind;
#define RMS_ObjectEventAdd
//fgt dem Objekt mit Index argument0 ins event argument1 (=String) den String argument2 als code ein
var obj,strpos,code,evtype,evnumb;
obj=argument0;
code=argument2;
strpos=string_pos("$",argument1);
evtype=string_copy(argument1,1,strpos-1);
evnumb=string_copy(argument1,strpos+1,string_length(argument1)-strpos);
execute_string("ev1="+evtype+";");
execute_string("ev2="+evnumb+";");
evtype=ev1;
evnumb=ev2;
//show_message("Vergleich: Create: "+string(ev_create)+" Alarm: "+string(ev_alarm)+" Aktuell: "+string(evtype));
//show_message(code);
object_event_add(obj,evtype,evnumb,code);
#define RMS_SaveRoom
//speichert den Room mit Index argument0 in die Datei argument1
//dazu wird allerdings der Raum gewechselt.
//rm=room;
//room_goto(argument0);
//screen_redraw();

var fhandle,i,ii;

fhandle=file_text_open_write(argument1);

//Registerkarte Settings
file_text_write_string(fhandle,string(room_width));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(room_height));
file_text_writeln(fhandle);
file_text_write_string(fhandle,room_caption);
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(room_persistent));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(room_speed));
file_text_writeln(fhandle);
//Registerkarte Views
file_text_write_string(fhandle,string(view_enabled));
file_text_writeln(fhandle);
for (i=0;i<=7;i+=1){
    file_text_write_string(fhandle,string(view_visible[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_xview[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_yview[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_wview[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_hview[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_xport[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_yport[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_wport[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_hport[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_angle[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_hborder[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_vborder[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_hspeed[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_vspeed[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,object_name(view_object[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(view_object[i]));
    file_text_writeln(fhandle);
}
//Registerkarte Backgrounds
file_text_write_string(fhandle,string(background_color));
file_text_writeln(fhandle);
file_text_write_string(fhandle,string(background_showcolor));
file_text_writeln(fhandle);
for (i=0;i<=7;i+=1){
    file_text_write_string(fhandle,string(background_visible[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(background_foreground[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,background_name(background_index[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(background_index[i])); 
    file_text_writeln(fhandle);  
    file_text_write_string(fhandle,string(background_x[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(background_y[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(background_htiled[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(background_vtiled[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(background_xscale[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(background_yscale[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(background_hspeed[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(background_vspeed[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(background_blend[i]));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(background_alpha[i]));
    file_text_writeln(fhandle);
}
for (i=0;i<instance_number(all);i+=1){
    ii=instance_find(all,i);
    if (i!=0){
        file_text_writeln(fhandle);
    } 
    file_text_write_string(fhandle,object_name(ii.object_index));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(ii.object_index));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(ii.x));
    file_text_writeln(fhandle);
    file_text_write_string(fhandle,string(ii.y));
}
file_text_close(fhandle);
if (room_next(room)!=-1){
    //show_message("Next room");
    strcode="global.cnt+=1";
    strcode+="ini_write_string('Rooms',string(global.cnt),room_get_name(room));";
    strcode+="RMS_SaveRoom(room,'RMSFiles\Rooms\'+room_name(room)+'.room')";
    var no;
    no=object_add();
    object_set_depth(no,100000000000000000);
    object_event_add(no,ev_create,0,strcode);
    room_instance_add(room_next(room),0,0,no);
    //room_set_code(room_next(room),strcode);
    room_goto_next();
    
    
    //ini_write_string("Rooms",string(global.cnt),room_name(room));
    //RMS_SaveRoom(room,"RMSFiles\Rooms\"+room_name(room)+".room");
}
else{
    game_end();
}






#define RMS_LoadRoom
//Ldt einen Room aus der Datei argument0 und gibt den Index zurck.
//Braucht das RMS!
//Wenn in dem Room verwaltete Objekte/Sprites o.. vorkommen, ist es
//wichtig, dass sie beim verlassen des Rooms ber RMS gelscht werden!
var fhandle,i,temp,ind,crea;
fhandle=file_text_open_read(argument0);
ind=room_add();
 //Registerkarte settings
room_set_width(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
room_set_height(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
room_set_caption(ind,file_text_read_string(fhandle));
file_text_readln(fhandle);
room_set_persistent(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
crea="room_speed="+file_text_read_string(fhandle)+";";
file_text_readln(fhandle);

 //Registerkarte views
var vind,vis,xview,yview,wview,hview,xport,yport,wport,hport,hborder,vborder,hsp,vsp,obj;
room_set_view_enabled(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
for (i=0;i<=7;i+=1){
    vind=i;
    vis=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    xview=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    yview=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    wview=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    hview=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    xport=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    yport=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    wport=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    hport=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    crea+="view_angle["+string(i)+"]="+file_text_read_string(fhandle)+";";
    file_text_readln(fhandle);
    hborder=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    vborder=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    hsp=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    vsp=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    //Das Objekt auslesen, hier wirds etwas komplizierter
    temp=file_text_read_string(fhandle);
    file_text_readln(fhandle);
    if (variable_global_exists(temp)){
        obj=RMS_Get(variable_global_get(temp),"Room:"+string(ind));
        file_text_readln(fhandle);
    }
    else{
        obj=real(file_text_read_string(fhandle));
        file_text_readln(fhandle);
    }
    room_set_view(ind,vind,vis,xview,yview,wview,hview,xport,yport,wport,hport,hborder,vborder,hsp,vsp,obj);
}

 //Registerkarte Backgrounds
var col,show;
var bind,vis,fore,back,xx,yy,htiled,vtiled,hsp,vsp,alpha;

col=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
show=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
room_set_background_color(ind,col,show);

 for (i=0;i<=7;i+=1){
    bind=i;
    vis=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    fore=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    //Hintergrundbild laden, kann auch komplizierter sein
    temp=file_text_read_string(fhandle);
    file_text_readln(fhandle);
    if (variable_global_exists(temp)){
        back=RMS_Get(variable_global_get(temp),"Room:"+string(ind));
        file_text_readln(fhandle);
    }
    else{
        back=real(file_text_read_string(fhandle));
        file_text_readln(fhandle);
    }
    xx=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    yy=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    htiled=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    vtiled=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    crea+="background_xscale["+string(i)+"]="+file_text_read_string(fhandle)+";";
    file_text_readln(fhandle);
    crea+="background_yscale["+string(i)+"]="+file_text_read_string(fhandle)+";";
    file_text_readln(fhandle);
    hsp=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    vsp=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    crea+="background_blend["+string(i)+"]="+file_text_read_string(fhandle)+";";
    file_text_readln(fhandle);
    alpha=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    room_set_background(ind,bind,vis,fore,back,xx,yy,htiled,vtiled,hsp,vsp,alpha);
}

var x1,y1,obj;
 //Objekte
while(file_text_eof(fhandle)==false){
    //objekttyp feststellen und bei Bedarf anfordern
    temp=file_text_read_string(fhandle);
    file_text_readln(fhandle);
    if (variable_global_exists(temp)){
        obj=RMS_Get(variable_global_get(temp),"Room:"+string(ind));
        file_text_readln(fhandle);
    }
    else{
        obj=real(file_text_read_string(fhandle));
        file_text_readln(fhandle);
    }
    x1=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    y1=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    room_instance_add(ind,x1,y1,obj);
}
room_set_code(ind,crea);
file_text_close(fhandle);
return ind;
#define RMS_LoadExRoom
//Ldt die Einstellungen fr einen Room aus der Datei argument0 
//in einen bereits existierenden Room argument1. Braucht das RMS!
//Wenn in dem Room verwaltete Objekte/Sprites o.. vorkommen, ist es
//wichtig, dass sie beim verlassen des Rooms ber RMS gelscht werden!
var fhandle,i,temp,ind,crea;
fhandle=file_text_open_read(argument0);
ind=argument1;
 //Registerkarte settings
room_set_width(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
room_set_height(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
room_set_caption(ind,file_text_read_string(fhandle));
file_text_readln(fhandle);
room_set_persistent(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
crea="room_speed="+file_text_read_string(fhandle)+";";
file_text_readln(fhandle);

 //Registerkarte views
var vind,vis,xview,yview,wview,hview,xport,yport,wport,hport,hborder,vborder,hsp,vsp,obj;
room_set_view_enabled(ind,real(file_text_read_string(fhandle)));
file_text_readln(fhandle);
for (i=0;i<=7;i+=1){
    vind=i;
    vis=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    xview=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    yview=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    wview=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    hview=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    xport=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    yport=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    wport=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    hport=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    crea+="view_angle["+string(i)+"]="+file_text_read_string(fhandle)+";";
    file_text_readln(fhandle);
    hborder=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    vborder=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    hsp=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    vsp=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    //Das Objekt auslesen, hier wirds etwas komplizierter
    temp=file_text_read_string(fhandle);
    file_text_readln(fhandle);
    if (variable_global_exists(temp)){
        obj=RMS_Get(variable_global_get(temp));
        file_text_readln(fhandle);
    }
    else{
        obj=real(file_text_read_string(fhandle));
        file_text_readln(fhandle);
    }
    room_set_view(ind,vind,vis,xview,yview,wview,hview,xport,yport,wport,hport,hborder,vborder,hsp,vsp,obj);
}

 //Registerkarte Backgrounds
var col,show;
var bind,vis,fore,back,xx,yy,htiled,vtiled,hsp,vsp,alpha;

col=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
show=real(file_text_read_string(fhandle));
file_text_readln(fhandle);
room_set_background_color(ind,col,show);

 for (i=0;i<=7;i+=1){
    bind=i;
    vis=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    fore=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    //Hintergrundbild laden, kann auch komplizierter sein
    temp=file_text_read_string(fhandle);
    file_text_readln(fhandle);
    if (variable_global_exists(temp)){
        back=RMS_Get(variable_global_get(temp));
        file_text_readln(fhandle);
    }
    else{
        back=real(file_text_read_string(fhandle));
        file_text_readln(fhandle);
    }
    xx=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    yy=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    htiled=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    vtiled=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    crea+="background_xscale["+string(i)+"]="+file_text_read_string(fhandle)+";";
    file_text_readln(fhandle);
    crea+="background_yscale["+string(i)+"]="+file_text_read_string(fhandle)+";";
    file_text_readln(fhandle);
    hsp=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    vsp=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    crea+="background_blend["+string(i)+"]="+file_text_read_string(fhandle)+";";
    file_text_readln(fhandle);
    alpha=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    room_set_background(ind,bind,vis,fore,back,xx,yy,htiled,vtiled,hsp,vsp,alpha);
}

var x1,y1,obj;
 //Objekte
while(file_text_eof(fhandle)==false){
    //objekttyp feststellen und bei Bedarf anfordern
    temp=file_text_read_string(fhandle);
    file_text_readln(fhandle);
    if (variable_global_exists(temp)){
        obj=RMS_Get(variable_global_get(temp));
        file_text_readln(fhandle);
    }
    else{
        obj=real(file_text_read_string(fhandle));
        file_text_readln(fhandle);
    }
    x1=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    y1=real(file_text_read_string(fhandle));
    file_text_readln(fhandle);
    room_instance_add(ind,x1,y1,obj);
}
room_set_code(ind,crea);
file_text_close(fhandle);
return ind;
